#include <SFML/Graphics.hpp>
#include <ZLE.hpp>

int main()
{
    sf::RenderWindow window(sf::VideoMode({400, 400}), "Particle example");
    window.setFramerateLimit(60);
    
    zle::ParticleSystem ps;
    ps.loadFromFile("test.part");
    ps.setPosition({ window.getSize().x / 2.f, window.getSize().y / 2.f });
    ps.setScale({ 8.f, 8.f });

    sf::Clock clk;
    while (window.isOpen())
    {
        while (auto event = window.pollEvent())
        {
            if (event->is<sf::Event::Closed>())
                window.close();
        }
        ps.Update(clk.restart());

        window.clear();
        window.draw(ps);
        window.display();
    }

    return 0;
}